/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.events.forge;

import com.mojang.datafixers.util.Either;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonController;
import net.mehvahdjukaar.supplementaries.client.hud.SelectableContainerItemHud;
import net.mehvahdjukaar.supplementaries.common.events.ClientEvents;
import net.mehvahdjukaar.supplementaries.common.items.SelectableContainerItem;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.SherdTooltip;
import net.mehvahdjukaar.supplementaries.common.misc.songs.SongsManager;
import net.mehvahdjukaar.supplementaries.common.utils.IQuiverPlayer;
import net.mehvahdjukaar.supplementaries.common.utils.SlotReference;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.event.sound.SoundEvent;
import net.minecraftforge.client.gui.overlay.NamedGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEventsForge {
    private static boolean hasOptifine;
    private static boolean firstScreenShown;
    private static double wobble;
    static boolean mutex;

    public static void init() {
        MinecraftForge.EVENT_BUS.register(ClientEventsForge.class);
    }

    @SubscribeEvent
    public static void onScreenDrawPost(ScreenEvent.Init.Post event) {
        if (!firstScreenShown && event.getScreen() instanceof TitleScreen) {
            ClientEvents.onFirstScreen(event.getScreen());
            firstScreenShown = true;
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (event.getEntity() != null) {
            ClientEvents.onItemTooltip(event.getItemStack(), event.getFlags(), event.getToolTip());
        }
    }

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        if (CompatHandler.CONFIGURED) {
            ClientEvents.addConfigButton(event.getScreen(), event.getListenersList(), arg_0 -> ((ScreenEvent.Init.Post)event).addListener(arg_0));
        }
    }

    @SubscribeEvent
    public static void onClientEndTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ClientEvents.onClientTick(Minecraft.m_91087_());
        }
    }

    @SubscribeEvent
    public static void onKeyPress(InputEvent.Key event) {
        int action = event.getAction();
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (mc.f_91080_ == null && ClientRegistry.QUIVER_KEYBIND.m_90832_(event.getKey(), event.getScanCode()) && player instanceof IQuiverPlayer) {
            IQuiverPlayer qe = (IQuiverPlayer)player;
            if (action == 2 || action == 1) {
                SelectableContainerItemHud.INSTANCE.setUsingKeybind(qe.supplementaries$getQuiverSlot(), (Player)player);
            } else if (action == 0) {
                SelectableContainerItemHud.INSTANCE.setUsingKeybind(SlotReference.EMPTY, (Player)player);
            }
        }
        if (CannonController.isActive() && action == 1) {
            int scanCode;
            int key = event.getKey();
            if (mc.f_91066_.f_92089_.m_90832_(key, scanCode = event.getScanCode())) {
                CannonController.onKeyJump();
            }
            if (mc.f_91066_.f_92090_.m_90832_(key, scanCode)) {
                CannonController.onKeyShift();
            }
            if (mc.f_91066_.f_92092_.m_90832_(key, scanCode)) {
                CannonController.onKeyInventory();
            }
        }
    }

    @SubscribeEvent
    public static void onMouseScrolled(InputEvent.MouseScrollingEvent event) {
        if (SelectableContainerItemHud.INSTANCE.onMouseScrolled(event.getScrollDelta())) {
            event.setCanceled(true);
        }
        if (CannonController.isActive()) {
            CannonController.onMouseScrolled(event.getScrollDelta());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClickInput(InputEvent.InteractionKeyMappingTriggered event) {
        if (CannonController.isActive()) {
            event.setCanceled(true);
            event.setSwingHand(false);
            if (event.isAttack()) {
                CannonController.onPlayerAttack();
            } else if (event.isUseItem()) {
                CannonController.onPlayerUse();
            }
        }
    }

    @SubscribeEvent
    public static void renderHandEvent(RenderHandEvent event) {
        if (CannonController.isActive()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderGuiOverlayPre(RenderGuiOverlayEvent.Pre event) {
        NamedGuiOverlay overlay;
        if (CannonController.isActive() && ((overlay = event.getOverlay()) == VanillaGuiOverlay.EXPERIENCE_BAR.type() || overlay == VanillaGuiOverlay.HOTBAR.type())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        boolean isOnRope;
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (p != null && !Minecraft.m_91087_().m_91104_() && ((isOnRope = ClientEvents.isIsOnRope()) || wobble != 0.0)) {
            double period = ClientConfigs.Blocks.ROPE_WOBBLE_PERIOD.get();
            double newWobble = ((double)p.f_19797_ + event.getPartialTick()) / period % 1.0;
            wobble = !isOnRope && newWobble < wobble ? 0.0 : newWobble;
            event.setRoll((float)((double)event.getRoll() + (double)Mth.m_14031_((float)((float)(wobble * 2.0 * Math.PI))) * ClientConfigs.Blocks.ROPE_WOBBLE_AMPLITUDE.get()));
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(ScreenEvent.Opening event) {
        Screen screen;
        if (!mutex && event.getNewScreen() instanceof DeathScreen && (screen = event.getCurrentScreen()) instanceof ChatScreen) {
            ChatScreen cs = (ChatScreen)screen;
            if (ClientConfigs.Tweaks.DEATH_CHAT.get().booleanValue()) {
                mutex = true;
                cs.m_5534_('-', 0);
                cs.m_7933_(257, 0, 0);
                mutex = false;
            }
        }
    }

    @SubscribeEvent
    public static void onSoundPlay(SoundEvent.SoundSourceEvent event) {
        SongsManager.recordNoteFromSound(event.getSound(), event.getName());
    }

    @SubscribeEvent
    public static void onGatherTooltipComponents(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        Item i = stack.m_41720_();
        ResourceKey pattern = DecoratedPotPatterns.m_271696_((Item)i);
        if (pattern != null && i != Items.f_42460_) {
            event.getTooltipElements().add(Either.right((Object)new SherdTooltip((ResourceKey<String>)pattern)));
        }
    }

    @SubscribeEvent
    public static void onRenderOutline(RenderHighlightEvent.Block event) {
        if (CannonController.isActive()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAddTooltips(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (item instanceof SelectableContainerItem) {
            SelectableContainerItem si = (SelectableContainerItem)item;
            ItemStack selected = si.getData(stack).getSelected();
            if (selected.m_41720_() instanceof SelectableContainerItem) {
                return;
            }
            RenderTooltipEvent.GatherComponents newEvent = new RenderTooltipEvent.GatherComponents(selected, event.getScreenWidth(), event.getScreenHeight(), event.getTooltipElements(), event.getMaxWidth());
            MinecraftForge.EVENT_BUS.post((Event)newEvent);
        }
    }

    static {
        mutex = false;
    }
}

